*-------------------------------------------------------------------------------
/* title : Set macros for regressors in markov process, instrumental variables 
		   (IV) and fixed effects (FE)
   input : $temp/Sample.dta
   output: store in memory all relevant variables needed for estimation */
*-------------------------------------------------------------------------------

macro drop markov_* Dmarkov_lag IVdif IVlev	FE 		// Ensure macros are empty

*-----------------------DECLARE REGRESSORS OF INTEREST--------------------------
foreach var of global markov {
	global markov_lag 	$markov_lag  L1_`var' 		// Equation in levels
	global Dmarkov_lag $Dmarkov_lag DL1_`var' 		// Equation in first-differences
}

*--------------------INSTRUMENTS FOR MARKOV REGRESSORS (IV)---------------------
* Declare use of internal or external IVs
if "$IVext"=="NO" local IV $markov 					// Internal IV
else 			  local IV $instruments 			// External IV

/*Use different lag lenghts across groups of variables to avoid IV proliferation
  Note: we refer to markov regressors other than the persistence term & FE.*/
unab short: *shh* *sub*
local long:  list IV - short 						// Variables for longer lags
local short: list IV - long 						// Variables for shorter lags

* IV for key regressors (country-industry-year-specific)
display "IV for key regressors: `long'"
foreach var of local long {
	forvalues i = 2/2 {
		global IVdif 	$IVdif L`i'_`var' 			// IV for markov process in first differences
	}
	forvalues i = 1/12 {
		global IVlev 	$IVlev DL`i'_`var' 			// IV for markov process in levels
	}
}

* IV for the remaining control variables
display "IV for additional controls: `short'"
foreach var of local short {
	forvalues i = 2/2 {
		global IVdif 	$IVdif L`i'_`var' 			// IV for markov process in first differences
	}
	forvalues i = 1/1 {
		global IVlev 	$IVlev DL`i'_`var' 			// IV for markov process in levels
	}
}

*-------------SET FE & TRENDS (USED IN MARKOV PROCESS) AS FACTORIALS------------
global FE const 									// Add a global constant (default)

* Fixed effects (dummies)
if "$FEj"=="YES" 	global FE $FE i.Gj 				// Industry
if "$FEc"=="YES" 	global FE $FE i.Gc 				// Country
if "$FEt"=="YES" 	global FE $FE i.Gt 				// Year
if "$FEjt"=="YES" 	global FE $FE i.Gj##i.Gt 		// Industry-year
if "$FEct"=="YES" 	global FE $FE i.Gc##i.Gt 		// Country-year

* Linear time trends
if "$TREND"=="YES" 	global FE $FE Gt 				// Global
if "$TRENDj"=="YES" global FE $FE i.Gj#c.Gt 		// Industry
if "$TRENDc"=="YES" global FE $FE i.Gc#c.Gt 		// Country

*----------------------------------SET FE LIST----------------------------------
fvexpand $FE if !missing(L1_y), noi 				// Expand all levels of the factor variables
global FElist `r(varlist)' 							// Set global macro with a list of all expanded levels of the factor variable FE

*-------------------------------------DISPLAY-----------------------------------
dis "FE: $FE" 										// Fixed effects for markov process in levels
dis "FE list: $FElist" 								// List of fixed effects used in second-step GMM estimation for equation in levels
dis "IV for equation in first-differences excluding persistence and FE: $IVdif"
dis "IV for equation in levels excluding persistence and FE: $IVlev"
